---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-Streaming Query List（ストリーミングクエリ一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryPage.scala` 行33-261
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryTab.scala` 行23-42
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` No.16
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.16
- E-05: `docs/code-to-docs/画面遷移図.md` StreamingQueryTab

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/StreamingQuery/ | E-02 行25: SparkUITab(sparkUI, "StreamingQuery") | ○ |
| C-02 | デフォルトページ | E-01 行34: WebUIPage("") | ○ |
| C-03 | Active/Inactive分割 | E-01 行42-43: partition(_.summary.isActive) | ○ |
| C-04 | Active Queriesセクション | E-01 行48-63 | ○ |
| C-05 | Completed Queriesセクション | E-01 行65-81 | ○ |
| C-06 | デフォルトソートはStart Time | E-01 行122: getTableParameters(request, tableTag, "Start Time") | ○ |
| C-07 | テーブルカラム: Name/Status/ID/Run ID/Start Time/Duration/Avg Input/Avg Process/Latest Batch | E-01 行152-161: headerAndCss定義 | ○ |
| C-08 | CompletedテーブルにのみErrorカラム | E-01 行162-166: !isActive条件 | ○ |
| C-09 | Run IDリンクが統計画面へ遷移 | E-01 行176-178: statisticsLink | ○ |
| C-10 | 平均レートはrecentProgressの平均 | E-01 行233-237: avgInput/avgProcess計算 | ○ |
| C-11 | 進捗なし時はNaN表示 | E-01 行195-197: withNoProgress使用 | ○ |
| C-12 | ページングテーブル（PagedTable継承） | E-01 行120: extends PagedTable[StructuredStreamingRow] | ○ |
| C-13 | displayOrderは2 | E-02 行37: override def displayOrder: Int = 2 | ○ |
| C-14 | ページタイトルは"Streaming Query" | E-01 行38: headerSparkPage引数 | ○ |
| C-15 | セクション折りたたみ機能 | E-01 行50-51: collapseTable onClick | ○ |
| C-16 | テーブルのCSSクラス | E-01 行128-129: tableCssClass定義 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面仕様がソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] StreamingQueryStatusStoreのデータ取得タイミングを確認
- [ ] 大量クエリ時のページング動作を確認
